/*
 * Title  : sho_idx_col.sql
 * Author : EXADIME LLC
 * Created: 02-Apr-2018
 * Updated: 01-Nov-2023
 * Release: 1.0.0
 * Purpose: This query shows the indexed columns of the given table.
 * Comment: Status N/A indicates that the index is a partitioned index.
 * History: Added column status. Refer Doc ID 445158.1 for status values.
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Index Name"	format a30
col "Index Type"	format a23
col "Column Name"	format a30
col "Position"		format 9999999
col "Tablespace Name"	format a30
col "Status"		format 99999999

accept p_owner char prompt "Enter Owner "
accept p_table_name char prompt "Enter Table Name "
accept p_order_col char prompt "Enter Order by column {1|2|3|4} [asc|desc] " default 1,2,3,4

spool &&rpt_dir/sho_idx_col.rpt

select 
        a.index_name "Index Name",
	b.index_type "Index Type",
	a.column_name "Column Name",
	a.column_position "Position",
	b.tablespace_name "Tablespace Name",
	b.status "Status"
from
        dba_ind_columns a,dba_indexes b
where
        a.table_name=upper('&p_table_name')
and	a.table_owner=upper('&p_owner')
and	a.index_name=b.index_name
and	a.table_owner=b.table_owner
order by
	&&p_order_col;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
