/*
 * Title  : sho_fk_col.sql
 * Author : EXADIME LLC
 * Created: 02-Apr-2018
 * Updated: 02-Apr-2018
 * Release: 1.0.0
 * Purpose: This script shows the Foreign Key column(s) in the given table.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Colunm Name" format a30
col "Constraint Name" format a30
col "Parent Table Name" format a30

accept p_owner char prompt "Enter Owner "
accept p_table_name char prompt "Enter Table Name "
accept p_order_col char prompt "Enter Order by column {1|2|3} [asc|desc] "

spool &&rpt_dir/sho_fk_col.rpt

select
	b.column_name "Colunm Name",
	(
                select table_name 
                from dba_constraints
                where constraint_name=a.r_constraint_name
		and owner=a.owner
        ) "Parent Table Name",
	b.constraint_name "Constraint Name"
from
	dba_constraints a,
	dba_cons_columns b
where
	a.constraint_name=b.constraint_name
and	a.constraint_type='R'	
and	b.table_name=upper('&&p_table_name')
and	a.owner=upper('&&p_owner')
order by
        &&p_order_col;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
