/*
 * Title  : sho_db_scn.sql
 * Author : EXADIME LLC
 * Created: 20-Sep-2017
 * Updated: 20-Sep-2017
 * Release: 1.0.0
 * Purpose: Shows database SCN.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column name		format a10		heading "DB Name"
column time	 	format a18		heading "DB Time"
column current_scn	format 99999999999999	heading "DB SCN"

spool &&rpt_dir/sho_db_scn.rpt

select 
	name,
	to_char(sysdate,'Mon dd, yyyy hh24:mi') time,
	current_scn
from 
	v$database;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off