/*
 * Title  : sho_db_rp.sql
 * Author : EXADIME LLC
 * Created: 02-Aug-2022
 * Updated: 15-Sep-2025
 * Release: 1.0.0
 * Purpose: Shows database restore points.
 * Comment: None
 * History: Adjusted restore point name column format to satisfy snapshot standby default restore point & filter.
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sn	format 99999            heading "#"
column name	format a45              heading "Name"
column scn	format 999999999999999  heading "SCN"
column inc      format 9999999	        heading "Incarnation"
column gnt	format a10		heading "Guarantee?"
column time     format a25		heading "Time"
column sz	format 999999999        heading "MB|Size"

accept p_name char prompt "Enter search string (Name): "
accept p_order char prompt "Enter order by column {1|2|3|4|5|6} [asc|desc]:" default "time desc"
accept p_rows  char prompt "Enter number of records to be displayed [10]: " default 10

spool &&rpt_dir/sho_db_rp.rpt

select
        row_number() over(order by &&p_order)  sn,
        name,
        scn,
	inc,
	gnt,
	time,
        sz
from (
	select 
	        name,
	        scn,
		database_incarnation# inc,
		guarantee_flashback_database gnt,
		to_char(time, 'Dy DD-Mon-YYYY HH24:MI:SS') as time,
	        storage_size/1024/1024 sz
	from 
		v$restore_point
	where
		name like upper('%&&p_name%')
	order by 
		&&p_order
)
where
	rownum<=&&p_rows;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
