/*
 * Title  : sho_blk_ses.sql
 * Author : EXADIME LLC
 * Created: 11-Dec-2022
 * Updated: 11-Dec-2022
 * Release: 1.0.0
 * Purpose: Shows blocked sessions including SQL text.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum			format 999999		heading "#"
column inst_id			format 999999		heading "Instance"
column sid			format 999999		heading "Session"
column serial#			format 999999		heading "Serial#"
column username			format a20		heading "Username"
column process			format a7		heading "Blocked|Process"
column blocking_instance 	format 999999		heading "Instance"
column blocking_session 	format 999999		heading "Session"
column blocking_session_status  format 999999		heading "Blocking|Status"
column seconds_in_wait          format 999999		heading "Seconds|Wait"
column sql_id                   format a13		heading "SQL Id"
column sql_fulltext             format a40		heading "SQL Text"

spool &&rpt_dir/sho_blk_ses.rpt

select 
	rownum,
	s.inst_id,
	s.sid,
	s.serial#,
        substr(s.username,1,20) username,
	s.process,
	s.blocking_instance,	
	s.blocking_session,
	s.blocking_session_status,
	s.seconds_in_wait,
	s.sql_id,
	substr(q.sql_fulltext,1,40) sql_fulltext
from 
	gv$process p,
	gv$sql q,
	gv$session s
where 
	s.sql_id=q.sql_id
and	s.sql_hash_value=q.hash_value
and	s.inst_id=q.inst_id
and	s.paddr=p.addr
and	s.blocking_session is not null
order by 
	blocking_session;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
