/*
 * Title  : ses_sp_dtrc.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: This script stops deep tracing the sql session for the given sid, serial#.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_sid number prompt 'Enter SID '
accept p_serial number prompt 'Enter Serial# '

spool &&rpt_dir/ses_sp_dtrc.rpt

begin
	sys.dbms_monitor.session_trace_disable(
		session_id=>&&p_sid,
		serial_num=>&&p_serial
	);
	dbms_output.put_line('Stopped monitoring the session with sid &&p_sid and serial# &&p_serial.');
end;
/

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
