/*
 * Title  : ses_seq_read.sql
 * Author : EXADIME LLC
 * Created: 16-Jun-2025
 * Updated: 16-Jun-2025
 * Release: 1.0.0
 * Purpose: Shows active sessions with high sequential read waits.
 * History: N/A
 * Comment: Use this to identify sessions causing high sequential reads.
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"			format 9999
col "inst_id"           format 9999		heading Node
col "sid"               format 99999		heading SID
col "total_waits"       format 99,999,999,999	heading "Total Waits"
col "time_waited"       format 99,999,999,999	heading "Time Waited"

spool &&rpt_dir/ses_seq_read.rpt

select 
	inst_id, sid, total_waits, time_waited 
from 
	gv$session_event 
where 
	event='db file sequential read' 
and total_waits>0 
and sid in (	
	select
		s.sid
	from
		gv$session s,
		gv$process p
	where
		s.paddr=p.addr(+)
	and	s.inst_id=p.inst_id
	and	s.username is not null
	and	p.background is null
	and	s.status='ACTIVE'
) order by 3,2 ;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
