/*
 * Title  : run_sql_mtr.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Run SQL Monitor to for given SQL Id.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 1000000

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_sql_id char prompt "Enter SQL Id: "
accept p_rpt_type char prompt "Enter Report Type {TEXT|HTML}: "

spool &&rpt_dir/run_sql_mtr.rpt

select 
	dbms_sqltune.report_sql_monitor(
	type=>nvl('&p_rpt_type','HTML'),
	report_level=>'ALL',
	sql_id=>'&p_sql_id') as report
FROM 
	dual;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off