/*
 * Title  : prof_info.sql
 * Author : EXADIME LLC
 * Created: 16-Jan-2025
 * Updated: 16-Jan-2025
 * Release: 1.0.0
 * Purpose: To show profile details for the given profile name.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 80
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"                  format 999
col "Resource Type"      format a15
col "Resource Name"      format a30
col "Limit"              format a30

accept p_profile prompt 'Enter Profile Name: '

spool &&rpt_dir/prof_info.rpt

select 
    row_number() over(order by resource_type, resource_name) "#",
    resource_type                                            "Resource Type",
    resource_name                                            "Resource Name",
    limit                                                    "Limit"
from 
    dba_profiles 
where 
    profile = upper('&&p_profile')
order by 
    resource_type,
    resource_name
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 200
set long 80

set termout on
set serverout off
set feedback on
set echo off
