/*
 * Title  : pass_info.sql
 * Author : EXADIME LLC
 * Created: 28-Sep-2024
 * Updated: 28-Sep-2024
 * Release: 1.0.0
 * Purpose: Shows password file information.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno       format 9999	heading "#"
column inst_id   format 9999	heading "Node"
column file_name format a60	heading "File"
column format    format a6	heading "format"
column is_asm    format a5	heading "ASM?"

accept p_order char prompt "Enter order by column {2|3|4|5} [asc|desc] " default 2,3

spool &&rpt_dir/pass_info.rpt

select 
	row_number() over(order by &&p_order)	sno,
	inst_id,
	file_name,
	format,
	is_asm 
from 
	gv$passwordfile_info
order by
	&&p_order;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
