/*
 * Title  : node_info.sql
 * Author : EXADIME LLC
 * Created: 03-Oct-2024
 * Updated: 03-Oct-2024
 * Release: 1.0.0
 * Purpose: To show all instance details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 120
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Id" 		format 999
col "Name" 		format a10
col "Host"		format a20
col "Role"		format a7
col "Version"		format a10
col "Thread"		format 999999
col "Status" 		format a7
col "Logins" 		format a10
col "Startup Time" 	format a18
col "Current Time" 	format a18

spool &&rpt_dir/node_info.rpt

select
	inst_id						"Id",
	instance_name					"Name",
	host_name					"Host",
	substr(instance_role,1,7)			"Role",
	version						"Version",
	thread#						"Thread",
	status						"Status",
	logins						"Logins",
	to_char(startup_time,'Mon dd, yyyy hh24:mi')	"Startup Time",
	to_char(sysdate,'Mon dd, yyyy hh24:mi')		"Current Time"
from
	gv$instance
order by
	inst_id
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 200
set long 80

set termout on
set serverout off
set feedback on
set echo off
