/*
 * Title  : list_sql_prof.sql
 * Author : EXADIME LLC
 * Created: 13-Sep-2021
 * Updated: 15-Sep-2022
 * Release: 1.0.0
 * Purpose: Shows SQL Profiles.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 120
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno			format 9999			heading "#"
column name			format a40			heading "Name"
column task_id			format 99999999			heading "Task Id"
column type			format a10			heading "Type"
column force_matching		format a15			heading "Force Matching"
column status			format a10			heading "Status"

accept p_order	char prompt "Enter order by column {1|2|3|4|5|6|7} [asc|desc]: " default "7 desc"

spool &&rpt_dir/list_sql_prof.rpt

select 
	row_number() over(order by &&p_order) sno,
	name,
	task_id, 
	type,
	force_matching, 
	status, 
	to_char(created, 'MM-DD-YYYY HH24:MI:SS') "Created"
from(
	select 
		name,
		task_id, 
		type,
		force_matching, 
		status, 
		created
	from	
		dba_sql_profiles	
) order by 
	&&p_order
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
