/*
 * Title  : list_base_line.sql
 * Author : EXADIME LLC
 * Created: 20-Aug-2021
 * Updated: 20-Aug-2021
 * Release: 1.0.0
 * Purpose: Lists all baselines.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno			format  9999    heading "#"
column sql_handle		format  a30    	heading "SQL Handle"
column plan_name		format  a30	heading "Plan Name"
column version			format  a20    	heading "Version"
column enabled			format  a7    	heading "Enabled"
column accepted			format  a8    	heading "Accepted"
column fixed			format  a5    	heading "Fixed"
column last_executed		format  a30    	heading "Last Executed"
column created			format  a30   	heading "Created"

accept p_order char prompt "Enter order by column {1|2|3|4|5|6|7|8|9} [asc|desc] " default 8

spool &&rpt_dir/list_base_line.rpt

select 
	row_number() over(order by &&p_order) sno,
	sql_handle,
	plan_name,
	version,
	enabled,
	accepted,
	fixed,
	created,
	last_executed
from (
	select 
		sql_handle,
		plan_name,			
		version,
		enabled,
		accepted,
		fixed,
		last_executed,
		created
	from 
		dba_sql_plan_baselines
)
order by
	&&p_order
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 200
set long 80

set termout on
set serverout off
set feedback on
set echo off