/*
 * Title  : dp_job_prg.sql
 * Author : EXADIME LLC
 * Created: 08-Sep-2016
 * Updated: 12-Sep-2025
 * Release: 1.0.0
 * Purpose: To check the data pump job progress.
 * Comment: None
 * History: Added filter on message.
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno              format 99999            heading "#"
column sofar		format 999999999	heading "Sofar"
column totalwork        format 999999999	heading "Total"
column pctcomp		format 999		heading "%|Complete"
column message		format a60		heading "Message"

spool &&rpt_dir/dp_job_prg.rpt

select 
	rownum sno,
	sofar,
	totalwork,
	sofar/totalwork*100 pctcomp,
	message 
from 
	V$SESSION_LONGOPS l,
	v$session s,
	DBA_DATAPUMP_SESSIONS p 
where 
	s.saddr=p.saddr
	and l.sid=s.sid
	and l.serial#=s.serial#
and
	message like '%EXPORT%';

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
