/*
 * Title  : dg_mrp_info.sql
 * Author : EXADIME LLC
 * Created: 14-Mar-2023
 * Updated: 14-Mar-2023
 * Release: 1.0.0
 * Purpose: Shows Data Guard managed recovery process (MRP) information. Run in any standby node.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 999		heading "#"
col process             format a10              heading "Process"
col instance_name	format a20		heading "Instance"
col host_name		format a20		heading "Host"
col thread#		format 999999    	heading "Thread"
col sequence#		format 999999999 	heading "Sequence#"
col status		format a15		heading "Status"

spool &&rpt_dir/dg_mrp_info.rpt

select
	rownum,
	s.process,
	i.instance_name,
	i.host_name,
	s.thread#,
	s.sequence#,
	s.status
from
	gv$managed_standby s,
	gv$instance i
where
	s.thread#=i.thread# (+)
and	s.process like 'MRP%';

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
