/*
 * Title  : dg_gap.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 12-Sep-2023
 * Release: 1.0.0
 * Purpose: To display data guard archive log gap. Run in primary.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum   format 9999	heading "#"
col dest_id  format 9999	heading "Dest Id"
col thread#  format 9999	heading "Thread"
col shipped  format 9999999	heading "Shipped"
col applied  format 9999999	heading "Gap|Applied"

compute sum of shipped on dest_id
compute sum of applied on dest_id

break on dest_id

accept p_dest char prompt "Enter destination Id: "

spool &&rpt_dir/dg_gap.rpt

select
	rownum,
	dest_id,
	thread#,
	(max_primary_log-max_shipped_log) shipped,
	(max_shipped_log-max_applied_log) applied
from (
	select
		dest_id,
		thread#, 
		max(sequence#) max_primary_log,
		max(decode(standby_dest,'YES', sequence#,0)) max_shipped_log,
		max(decode(applied,'YES',sequence#,0)) max_applied_log
	from
		v$archived_log
	where
		first_time > (select max(resetlogs_time) from v$archived_log) and standby_dest='YES'
	and	dest_id like '%&&p_dest%'
	group by
		dest_id, thread#
	order by
		dest_id, thread#
);

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
