/*
 * Title  : dg_cnf.sql
 * Author : EXADIME LLC
 * Created: 06-Oct-2024
 * Updated: 06-Oct-2024
 * Release: 1.0.0
 * Purpose: Shows data guard configuration.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum	    format 9999	heading "#"
col db_unique_name  format a20	heading "Name"
col dest_role       format a16	heading "Role"

spool &&rpt_dir/dg_cnf.rpt

select
	rownum,
	db_unique_name,
	dest_role
from 
	v$dataguard_config;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
