/*
 * Title  : cre_tune_set.sql
 * Author : EXADIME LLC
 * Created: 28-Mar-2018
 * Updated: 28-Mar-2018
 * Release: 1.0.0
 * Purpose: To create SQL Tuning Set.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_sts_name char prompt "Enter SQL Tuning Set Name: "
accept p_sts_desc char prompt "Enter SQL Tuning Set Desc: "

spool &&rpt_dir/cre_tune_set.rpt

BEGIN
	DBMS_SQLTUNE.CREATE_SQLSET(
		sqlset_name => '&&p_sts_name',
		description => '&&p_sts_desc'
	);
END;
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
