/*
 * Title  : asm_disk_list.sql
 * Author : EXADIME LLC
 * Created: 11-Oct-2019
 * Updated: 31-Oct-2023
 * Release: 1.0.0
 * Purpose: shows ASM disks.
 * History: Replaced total_mb with os_mb to see size of candidate disks.
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 150
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno      format 999	  heading "#"
column gname	format a25	  heading "Group"
column dname	format a25	  heading "Disk"
column head	format a10	  heading "Header"
column path	format a50	  heading "Path"
column state    format a12        heading "State"
column os_mb    format 9,999,999  heading "MBytes|Size"

break on gname noduplicates

accept p_txt char prompt "Enter search string (E.g. DATA): "
accept p_order char prompt "Enter order by column {1|2|3|4|5|6|7} [asc|desc] " default 2,3,4

spool &&rpt_dir/asm_disk_list.rpt

select
	row_number() over(order by &&p_order) sno,
	g.name gname,
	d.name dname,
	d.path,
	d.header_status head,
	d.state,
	d.os_mb
from
	v$asm_disk d,
	v$asm_diskgroup g
where
	d.group_number=g.group_number (+)
and	(d.name like upper('%&&p_txt%') or g.name like  upper('%&&p_txt%') or d.path like  upper('%&&p_txt%'))
order by
	&&p_order
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
