::-/*
::- Title  : win_rsn_bkp.bat
::- Author : EXADIME LLC
::- Created: 29-Jun-2017
::- Updated: 29-Jun-2017
::- Release: 1.0.0
::- Purpose: Rsync backup in Windows.
::- History: N/A
::-*/

rem Input
set TARGET=<UID>@<Server>::<Module>
set RSYNC_PASSWORD=<Password>

rem Environment
set TIME_STAMP=%date:~10,4%%date:~4,2%%date:~7,2%%time:~0,2%%time:~3,2%%time:~6,2%
set PATH=%PATH%;c:\oracle\scripts\exc\lib;c:\oracle\scripts\exc\dll
set LOG_FILE=c:\oracle\scripts\exc\log\<Hostname>_%TIME_STAMP%.log

rem Body
echo *** C DRIVE FILES *** > %LOG_FILE%
rsync --chmod=a=r,u+w,D+x -p -r -v -z -t --delete-after --stats --exclude "System Volume Information" /cygdrive/c/oracle/scripts %TARGET%/<Hostname>/C >> %LOG_FILE%
echo *** D DRIVE FILES *** >> %LOG_FILE%
rsync --chmod=a=r,u+w,D+x -p -r -v -z -t --delete-after --stats --exclude "System Volume Information" --exclude *RECYCLE.BIN /cygdrive/d/ %TARGET%/<Hostname>/D >> %LOG_FILE%
 
rem Report
c:\oracle\scripts\exc\lib\mail /x c:\oracle\scripts\exc\lib\mail.xml /s /to <Email> /sub "<Hostname> Rsync Backup" /btxt %LOG_FILE%