#-/*
#- Title  : run_crn_job.ksh
#- Author : EXADIME LLC
#- Created: 29-Jun-2017
#- Updated: 03-Nov-2020
#- Release: 1.0.0
#- Purpose: This script runs the given cron job. This script should be run on database server.
#- History: N/A
#-*/

#Header
#1.Declarations
exa_home="/home/oracle/scripts/exa"

#2.Inputs
while [ "${#}" != "0" ]
do
        case ${1} in
                 -file|-f)
                shift
                if [ "${1}" != "" ]
                then
                        file=${1}
                        shift
                fi
                ;;
               -h|-help)
                echo ""
                echo "Argument         Description"
                echo "---------------------------------------------------------"                
                echo "-file|-f         File to execute."
                echo "Note: Enclose file and its arguments in double quotes."
                exit 0;
                ;;
                *)
                echo "Bad argument: ${1}"
                echo "Use -help option to see correct usage."
                exit 0;
                ;;
        esac
done

#3.Validate Entries
if [ "${file}" = "" ]
then
	echo "Exc file entry is blank!"
fi

#Environment Settings
. ${exa_home}/ini/unix.ini

#4.Sanity Checks
#4.1.Check cron log. Create if not found.
if ! [ -f ${log_dir}/mnt_exc_crn.log ]
then
	touch ${log_dir}/mnt_exc_crn.log
	chmod 644 ${log_dir}/mnt_exc_crn.log
fi

#Body
#1.Log file name with timestamp.
echo `hostname`:`date` >> ${log_dir}/mnt_exc_crn.log
echo `hostname`:${exc_file} >> ${log_dir}/mnt_exc_crn.log

#2.Run exc file.
ksh ${file} >> ${log_dir}/mnt_exc_crn.log

#3.Backup cron.
if ! [ -f ${crn_dir}/`hostname`_${date_stamp}.crn ]
then
	crontab -l > ${crn_dir}/`hostname`_${date_stamp}.crn
fi
