/*
 * Title  : stat_win_off.sql
 * Author : EXADIME LLC
 * Created: 12-Jun-2024
 * Updated: 12-Jun-2024
 * Release: 1.0.0
 * Purpose: To disable statistics gathering job window.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_win	prompt "Enter Window Name: "

spool &&rpt_dir/stat_win_off.rpt

begin
	dbms_auto_task_admin.disable(client_name => 'auto optimizer stats collection', operation => NULL, window_name => upper('&&p_win'));
end;
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off