/*
 * Title  : sho_ses_dtl.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Shows session details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on

set linesize 150
set pagesize 24

set heading on
set headsep on
set underline on
set colsep " "

set verify off
set escape off
set embedded on

col "SID"		format 999
col "Serial#"		format 9999999
col "User Name"		format a20
col "Logon Time"	format a20
col "Machine"		format a20
col "SQL Trace"		format a10
col "PID"		format 999
col "SPID"		format 99999
col "Trace ID"		format a10

accept p_sid prompt 'Enter SID '

spool &&rpt_dir/sho_ses_dtl.rpt

select
	s.sid						"SID",
	s.serial#					"Serial#",
	s.username					"User Name",
	to_char(s.logon_time,'dd-mon-yyyy hh:mi:ss')	"Logon Time",
	s.machine					"Machine",
	s.sql_trace					"SQL Trace",
	p.pid						"PID",
	p.spid						"SPID",
	p.traceid					"Trace ID"
from
	v$session s,
	v$process p
where
	s.paddr=p.addr
and	s.sid=&&p_sid;

spool off;

clear columns

set embedded off
set escape off
set verify on

set colsep " "
set underline on
set headsep on
set heading on

set pagesize 24
set linesize 80

set serverout off
set feedback on
set echo off
