/*
 * Title  : sho_rac_con.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: This script shows RAC connections.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "SID"		format 9999
col "Serial#"		format 9999999
col "User Name"		format a15
col "Inst ID"		format 9999999
col "Service Name"	format a15
col "Logon Time"	format a17
col "F/O Type"		format a8
col "F/O Method"	format a10
col "F/O?"		format a4

accept p_machine	prompt 'Enter Machine: '

spool &&rpt_dir/sho_rac_con.rpt

select
	sid						"SID",
	serial#						"Serial#",
	substr(username,1,15)				"User Name",
	inst_id						"Inst Id",
	substr(service_name,1,15)			"Service Name",
	to_char(logon_time,'dd-Mon-yyyy hh24:mi')	"Login Time",
	failover_type					"F/O Type",
	failover_method					"F/O Method",
	failed_over					"F/O?"
from
	gv$session
where
	machine='&&p_machine';

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
