/*
 * Title  : sho_idx_size.sql
 * Author : EXADIME LLC
 * Created: 28-Jul-2022
 * Updated: 28-Jul-2022
 * Release: 1.0.0
 * Purpose: This script shows the index size for the given index.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sn           format 99999            heading "#"
column sch          format a30              heading "Owner"
column idx          format a30              heading "Index"
column mbytes       format 999,999,999      heading "MB|Size"

accept p_owner  char prompt "Enter Owner: "
accept p_index char prompt "Enter Index: "

spool &&rpt_dir/sho_idx_size.rpt

select
       row_number() over(order by &&p_order)  sn,
       sch,
       idx,
       bytes/1024/1024 mbytes
from (
        select
               owner sch,
               segment_name idx,
               bytes
        from
                dba_segments
        where
                segment_type in ('INDEX','INDEX PARTITION', 'INDEX SUB PARTITION')
        and
                owner=upper('&&p_owner')
        and
                segment_name in upper('&&p_index')
        order by
                &&p_order
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
