/*
 * Title  : sho_host_cpu.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Show host cpu utilization.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sn	format 999	heading "#"
column dt	format a10	heading "Date"
column tm	format a8	heading "Time"
column pu	format 999	heading "%|Used"

accept p_rownum char prompt "Enter Record Count [1-100]" default 1
accept p_order char prompt "Enter order [asc|desc] "

spool &&rpt_dir/sho_host_cpu.rpt

select  
	rownum					sn,
	to_char(begin_time,'MM/DD/YYYY')	dt,
	to_char(begin_time,'HH:MI AM')		tm,
	value					pu
from
	v$sysmetric_history
where
	metric_name like 'Host CPU Utilization%'
and	rownum<=&&p_rownum
order by
	1 &&p_order
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
