/*
 * Title  : sho_fb_time.sql
 * Author : EXADIME LLC
 * Created: 22-Sep-2025
 * Updated: 22-Sep-2025
 * Release: 1.0.0
 * Purpose: shows the oldest available fashback log.
 * Comment: To perform database recovery.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum	format 999		heading "#"
col time	format a21		heading "Flashback Time"
col scn		format 99999999999999	heading "SCN"

select 
	rownum,
	to_char(oldest_flashback_time,'Mon dd, yyyy hh:mi AM') time,
	oldest_flashback_scn scn
from 
	v$flashback_database_log;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
