/*
 * Title  : sga_free.sql
 * Author : EXADIME LLC
 * Created: 01-Jun-2021
 * Updated: 01-Jun-2021
 * Release: 1.0.0
 * Purpose: Shows free space in SGA.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno      format 9999             heading "#"
column total_mb	format 9,999,999	heading "Total"
column used_mb	format 9,999,999	heading "Used"
column free_mb	format 9,999,999	heading "MB|Free"
column pct_used	format 9,999,999	heading "%|Used"

spool &&rpt_dir/sga_free.rpt

select 
	rownum sno,
	round(tot.bytes /1024/1024 ,2) total_mb,
	round(used.bytes /1024/1024 ,2) used_mb, 
	round(free.bytes /1024/1024 ,2) free_mb, 
	(round(used.bytes /1024/1024 ,2)/round(tot.bytes /1024/1024 ,2))*100 pct_used
from 
	(select 
		sum(bytes) bytes
	from 
		v$sgastat
	where 
		name != 'free memory') used, 
	(select 
		sum(bytes) bytes
	from 
		v$sgastat
	where 
		name = 'free memory') free, 
	(select 
		sum(bytes) bytes
	from 
		v$sgastat) tot;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
