/*
 * Title  : sch_ses_info.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 07-Oct-2020
 * Release: 1.0.0
 * Purpose: Shows session details for the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 250
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"			format 9999
col "Node"              format 9999
col "SID"               format 99999
col "Serial#"		format 9999999
col "User Name"		format a30
col "Logon Time"        format a20
col "Machine"		format a20
col "Program"           format a25
col "SQL Id"            format a13      justify right
col "PID"               format 99999
col "SPID"              format a10
col "SQL Trace"		format a10      noprint
col "Trace ID"		format a10      noprint
col "Status"            format a10
col "State"             format a20
col "Event"             format a30

accept p_schema prompt 'Enter schema name: '
accept p_order char prompt "Enter order by column {1|2|3|5|6|13} [asc|desc] " default status

spool &&rpt_dir/sch_ses_info.rpt

select
	row_number() over(order by &&p_order)         "#",
	inst_id                                       "Node",
	sid                                           "SID",
	serial#                                       "Serial#",
	username                                      "User Name",
	to_char(logon_time,'dd-mon-yyyy hh:mi:ss')    "Logon Time",
	machine                                       "Machine",
	substr(program,1,25)                          "Program",
	nvl(sql_id,'-------------')                   "SQL Id",
	pid                                           "PID",
	spid                                          "SPID",
	sql_trace                                     "SQL Trace",
	traceid                                       "Trace ID",
	status                                        "Status",
	state					      "State",
	substr(event,1,30)                            "Event"
from (
	select
		s.inst_id,
		s.sid,
		s.serial#,
		s.username,
		s.logon_time,
		s.machine,
		s.program,
		s.sql_id,
		p.pid,
		p.spid,
		s.sql_trace,
		p.traceid,
		s.status,
		s.state,
		s.event
	from
		gv$session s,
		gv$process p
	where
		s.paddr=p.addr(+)
	and	s.username=upper('&&p_schema')
	and	p.background is null
)
order by
	&&p_order
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
