/*
 * Title  : sch_obj_cnt.sql
 * Author : EXADIME LLC
 * Created: 10-Aug-2021
 * Updated: 10-Aug-2021
 * Release: 1.0.0
 * Purpose: This script shows object count for the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Owner" format a30
col "Object Type" format a30
col "Object Count" format 999,999,999,999

compute sum of "Object Count" on report

break on report

accept p_schema char prompt "Enter schema name "
accept p_order char prompt "Enter order by column {1|2} [asc|desc] " default 1,2

spool &&rpt_dir/sch_obj_cnt.rpt

select 
	owner		"Owner",
	count(1)	"Object Count"
from	
	dba_objects
where	
	owner in (
		upper('&&p_schema')
	)
and	object_name not like 'BIN$%'
group by
	owner
order by
	&&p_order;

select 
	owner		"Owner",
	object_type	"Object Type",
	count(1)	"Object Count"
from	
	dba_objects
where	
	owner in (
		upper('&&p_schema')
	)
and	object_name not like 'BIN$%'
group by
	owner,object_type
order by
	&&p_order;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
