/*
 * Title  : sch_dis_rcon.sql
 * Author : EXADIME LLC
 * Created: 30-Mar-2018
 * Updated: 30-Mar-2018
 * Release: 1.0.0
 * Purpose: To disable referencial constraints in the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept sch_name char prompt 'Enter Schema Name: '

spool &&tmp_dir/sch_dis_rcon.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/sch_dis_rcon.rpt
prompt

select
	'ALTER TABLE ' || owner || '.' || table_name || 
	' DISABLE CONSTRAINT ' || constraint_name || chr(10) || '/'
from
	dba_constraints
where
	owner=upper('&&sch_name')
and	constraint_type='R'
and	status='ENABLED'
/

prompt spool off

spool off

prompt Run the script "&&tmp_dir/sch_dis_rcon.tmp" manually.
prompt

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on
