/*
 * Title  : dg_sts.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 02-Apr-2024
 * Release: 1.0.0
 * Purpose: Data Guard Status
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum	format 999999	heading "#"
col inst_id	format 999999	heading "Thread"
col timestamp   format a16      heading "Timestamp"
col error_code	format 99999	heading "Error Code"
col message 	format a100 	heading "Message"

accept p_inst_id char prompt "Enter Instance Id: " default 1

spool &&rpt_dir/dg_sts.rpt

select
	rownum,
	inst_id,
	to_char(timestamp, 'yyyymmdd hh24:mi')	timestamp,
	error_code,
	message
from
	gv$dataguard_status
where
	inst_id=&&p_inst_id;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
