/*
 * Title  : awr_undo_hist.sql
 * Author : EXADIME LLC
 * Created: 27-Jun-2022
 * Updated: 27-Jun-2022
 * Release: 1.0.0
 * Purpose: Shows undo tablespace usage captured in awr.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum	       format 9999        heading "#"
column snap_id	       format 999999999   heading "SnapId"
column instance_number format 99999       heading "Instance"
column begin_time      format a20	  heading "Begin Time"
column end_time        format a20	  heading "End Time"
column maxquerysqlid   format a13         heading "Query SQL ID"
column maxquerylen     format 99,999      heading "Max|Query Length"
column undotsn	       format 99999	  heading "Undo TSN"
column undoblks	       format 99,999      heading "Undo Blocks"
column txncount        format 99,999,999  heading "TXN Count"

accept p_bsnap	prompt "Enter Begin Snap Id: "
accept p_esnap	prompt "Enter End Snap Id: "
accept p_order	prompt "Enter sort order [asc|desc]: "

spool &&rpt_dir/awr_undo_hist.rpt

select
	rownum,
	t.*
from (
	select
		snap_id,
		instance_number,
		to_char(begin_time, 'MM/DD/YYYY HH24:MI:SS') begin_time,
		to_char(end_time, 'MM/DD/YYYY HH24:MI:SS') end_time,		
		maxquerysqlid,
		maxquerylen,
		undotsn, 
		undoblks, 
		txncount		
	from
		dba_hist_undostat
	where
		snap_id>=&p_bsnap
	and
		snap_id<=&p_esnap
	order by
		snap_id &&p_order
) t;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 150
set long 80

set termout on
set serverout off
set feedback on
set echo off
