/*
 * Title  : awr_load_sts.sql
 * Author : EXADIME LLC
 * Created: 28-Mar-2018
 * Updated: 28-Mar-2018
 * Release: 1.0.0
 * Purpose: Loads SQL Tuning Set from AWR.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_bsnap char prompt "Enter Begin Snap Id: "
accept p_esanp char prompt "Enter End Snap Id: "
accept p_sqlid char prompt "Enter SQL Id: "
accept p_sts_name char prompt "Enter SQL Tuning Set Name: "

spool &&rpt_dir/awr_load_sts.rpt

DECLARE
	cur sys_refcursor;
BEGIN
	OPEN cur FOR
	SELECT VALUE(P)
	FROM TABLE(
		dbms_sqltune.select_workload_repository(begin_snap=>&&p_bsnap, end_snap=>&&p_esnap,basic_filter=>'sql_id = ''&&p_sqlid''',attribute_list=>'ALL')
	) p;
	DBMS_SQLTUNE.LOAD_SQLSET( sqlset_name=> '&&p_sts_name', populate_cursor=>cur);
	CLOSE cur;
END;
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
