/*
 * Title  : awr_iops_hist.sql
 * Author : EXADIME LLC
 * Created: 10-Dec-2018
 * Updated: 04-Nov-2021
 * Release: 1.0.0
 * Purpose: Shows IOPS history captured in awr.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column "Serial Number"	format a3
column snid		format 999999		heading "SnapId"
column time		format a15		heading "Time"
column value		format 99,999,999	heading "IOPS"

accept p_bsnap	prompt "Enter Begin Snap Id: "
accept p_esnap	prompt "Enter End Snap Id: "
accept p_order	prompt "Enter sort order [asc|desc]: " default asc

spool &&rpt_dir/awr_iops_hist.rpt

select
	row_number() over(order by snap_id &&p_order)		"#",
	snap_id							snid,
	to_char(begin_interval_time,'yyyymmdd hh24:mi')		time,
	ceil(value)						value
from 
	(
		select 
			s.snap_id,
			s.begin_interval_time,
			max(value) value
		from 
			dba_hist_snapshot s, dba_hist_sysmetric_history t
		where
			s.snap_id = t.snap_id
		and	s.instance_number = t.instance_number 
		and	s.dbid = t.dbid
		and	s.instance_number = (select instance_number from v$instance)
		and	s.dbid = (select dbid from v$database)
		and	t.metric_name = 'I/O Requests per Second'
		and	s.snap_id between &p_bsnap and &p_esnap
		group by
			s.snap_id,
			s.begin_interval_time
) order by
	snap_id &&p_order;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off