/*
 * Title  : syn_info.sql
 * Author : EXADIME LLC
 * Created: 22-Jan-2026
 * Updated: 22-Jan-2026
 * Release: 1.0.0
 * Purpose: Shows details of the given synonym.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 80
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 999	heading "#"
col owner		format a30	heading "Synonym Owner"
col table_name		format a30	heading "Synonym Name"
col table_owner		format a30	heading "Table Owner"
col status		format a16	heading "Status"

accept p_own char prompt "Enter Synonym Owner: "
accept p_syn char prompt "Enter Synonym Name: "

spool &&rpt_dir/syn_info.rpt

select 
	rownum,
	s.owner,
	s.table_name,
	s.table_owner,
	o.status
from
	dba_objects o,
	dba_synonyms s
where
	o.object_name=s.synonym_name
and	o.owner=s.owner
and	s.owner=upper(trim('&&p_own'))
and	s.synonym_name=upper(trim('&&p_syn'));

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
