/*
 * Title  : stat_win_task.sql
 * Author : EXADIME LLC
 * Created: 18-Jun-2024
 * Updated: 18-Jun-2024
 * Release: 1.0.0
 * Purpose: To check client/task for the given gathering job window.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 99	heading "#"
col window_name		format a30	heading "Window Name"
col optimizer_stats	format a10	heading "Optimizer"
col autotask_status	format a10	heading "Advisor"

spool &&rpt_dir/stat_win_task.rpt

select 
	rownum,
	window_name,
	optimizer_stats, 
	autotask_status
from 
	dba_autotask_window_clients;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
