/*
 * Title  : stat_job_hist.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 08-Jan-2026
 * Release: 1.0.0
 * Purpose: Shows auto statistics gathering job history.
 * Comment: None
 * History: Client Name and Error added.
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 180
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col sno			format 9999	heading "#"
col client_name		format a31	heading "Name"
col window_name		format a20	heading "Window"
col start_time		format a20	heading "Start Time"
col job_duration	format a15	heading "Duration"
col job_status		format a10	heading "Status"
col job_error		format 99999	heading "Error"
col information		format a40	heading "Information"

accept p_txt char prompt "Enter search string (E.g. Client Name/Window Name/Status): "
accept p_order char prompt "Enter order by column {1|2|3|4|5|6} [asc|desc] " default "4 desc"
accept p_top	prompt "Enter top rows [10]: " default 10;

spool &&rpt_dir/stat_job_hist.rpt

select
	row_number() over(order by &&p_order)		sno,
	client_name,
	window_name,
	to_char(job_start_time,'yyyy-mm-dd hh:mi:ss')	start_time,
	job_duration,
	job_status,
	job_error,
	substr(job_info,1,40)				information
from (
	select
		client_name,
		window_name,
		job_start_time,
		job_duration,
		job_status,
		job_error,
		job_info
	from
		dba_autotask_job_history
	where
		(client_name like lower('%&&p_txt%') or window_name like upper('%&&p_txt%') or job_status like upper('%&&p_txt%'))
	order by
		job_start_time desc
)
where
	rownum<=&&p_top
order by
	&&p_order
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
