/*
 * Title  : ssl_info.sql
 * Author : EXADIME LLC
 * Created: 04-Dec-2023
 * Updated: 04-Dec-2023
 * Release: 1.0.0
 * Purpose: To verify if SSL is being used in the connection.
 * Comment: If protocol shows as "tcps" means SSL being used.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno	format 99		heading "#"
column name	format a8		heading "Protocol"
column ssl 	format a5		heading "SSL?"

spool &&rpt_dir/ssl_info.rpt

select 
	rownum sno,
	sys_context('USERENV','network_protocol') name,
	decode(sys_context('USERENV','network_protocol'),'tcps','Yes','No') ssl
from
	dual;

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
