/*
 * Title  : sho_tab_size.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 31-Aug-2022
 * Release: 1.0.0
 * Purpose: This script shows the table size.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sn           format 99999            heading "#"
column sch          format a30              heading "Owner"
column tab          format a30              heading "Table"
column mbytes       format 999,999,999      heading "MB|Size"

accept p_owner  char prompt "Enter Owner: "
accept p_table char prompt "Enter Table: "

spool &&rpt_dir/sho_tab_size.rpt

select
       row_number() over(order by 3)  sn,
       sch,
       tab,
       mbytes
from (
        select
	       owner sch,
               segment_name tab,
               sum(bytes)/1024/1024 mbytes
        from
                dba_segments
        where
                segment_type in ('TABLE','TABLE PARTITION', 'TABLE SUB PARTITION','LOB PARTITION','LOBSEGMENT')
        and
                owner=upper('&&p_owner')
        and
                segment_name in upper('&&p_table')
	group by
		owner, segment_name
        order by
                3
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
