/*
 * Title  : sho_scn_log.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Shows log seq# for the given SCN.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column thread#		format 999999		heading "Thread"
column sequence#	format 99999999		heading "Sequence"
column time		format a16		heading "Time"
column name		format a60		heading "Name"
column archived		format a9		heading "Archived?"
column applied		format a8		heading "Applied?"
column deleted		format a8		heading "Deleted?"

accept p_scn char prompt "Enter SCN: "

spool &&rpt_dir/sho_scn_log.rpt

select 
	thread#, 
	sequence#,
	to_char(first_time,'YYYYMMDD HH24:MI') time,
	name,
	archived,
	applied,
	deleted
from 
	v$archived_log
where 
	&p_scn between first_change# and next_change#;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off