/*
 * Title  : sho_sch_ses.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 03-Dec-2018
 * Release: 1.0.0
 * Purpose: Shows session details for the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"			format 9999
col "SID"		format 9999
col "Serial#"		format 9999999
col "User Name"		format a20
col "Logon Time"	format a20
col "Machine"		format a20
col "SQL Trace"		format a10
col "PID"		format 99999
col "SPID"		format a10
col "Trace ID"		format a10
col "Status"            format a8

accept p_user char prompt "Enter schema name: "
accept p_status char prompt "Enter session status [ACTIVE|INACTIVE|KILLED]: "

spool &&rpt_dir/sho_sch_ses.rpt

select
	rownum						"#",
	s.sid						"SID",
	s.serial#					"Serial#",
	s.username					"User Name",
	to_char(s.logon_time,'dd-mon-yyyy hh:mi:ss')	"Logon Time",
	s.machine					"Machine",
	s.sql_trace					"SQL Trace",
	p.pid						"PID",
	p.spid						"SPID",
	p.traceid					"Trace ID",
	s.status                                        "Status"
from
	v$session s,
	v$process p
where
	s.paddr=p.addr
and	s.status=upper('&&p_status')
and	p.program<>'PSEUDO'
and	p.background is null
and     s.username=upper('&&p_user');

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
