/*
 * Title  : sho_sch_bw.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Schema's current bandwith usage.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on

set linesize 120
set pagesize 100

set heading on
set headsep on
set underline on
set colsep " "

set verify off
set escape off
set embedded on

col "usn"	heading "Schema Name"		format	a30
col "svc"	heading "Service Name"		format  a15
col "sid"	heading "Session ID"		format  999,999,999
col "lgt"	heading "Logon Time"		format	a18
col "sts"	heading "Status"		format	a10
col "val"	heading "Bytes|Bandwidth"	format	999,999,999,999

compute sum of val on report
break on report

accept p_usn prompt 'Enter Schema Name: '

spool &&rpt_dir/sho_sch_bw.rpt

select
	a.username					usn,
	a.service_name					svc,
	a.sid						sid,
	to_char(a.logon_time, 'yyyymmdd hh24:mi')	lgt,
	a.status					sts,
	sum(b.value)					val
from
	v$session	a,
	v$sesstat	b,
	v$statname	c
where
	a.sid=b.sid
and	b.statistic#=c.statistic#
and	c.name like '%SQL%'
and	a.username=upper('&&p_usn')
group by
	a.username,
	a.service_name,
	a.sid,
	to_char(a.logon_time, 'yyyymmdd hh24:mi'),
	a.status
order by
	1,2,3 asc;

spool off;

clear columns

set embedded off
set escape off
set verify on

set colsep " "
set underline on
set headsep on
set heading on

set pagesize 24
set linesize 80

set serverout off
set feedback on
set echo off
