/*
 * Title  : sho_redo_log.sql
 * Author : EXADIME LLC
 * Created: 09-Jul-2025
 * Updated: 09-Jul-2025
 * Release: 1.0.0
 * Purpose: Shows redo log information.
 * Comment: None
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum		format 9999	heading "#"
column inst_id		format 999,999	heading "Node"
column thread#		format 999,999	heading "Thread"
column group#		format 999,999	heading "Group"
column sequence#	format 999,999	heading "Sequence"
column file_size	format 999,999	heading "MB|Size"
column members		format 999,999	heading "Members"
column archived		format a10	heading "Archived?"
column status		format a10	heading "Status"

spool &&rpt_dir/sho_redo_log.rpt

select
	rownum,
	inst_id,
	thread#,
	group#,
	sequence#,
	bytes/1024/1024 file_size,
	members,
	archived,
	status
from
	gv$log;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
