/*
 * Title  : sho_last_sql.sql
 * Author : EXADIME LLC
 * Created: 19-Jan-2023
 * Updated: 19-Jan-2023
 * Release: 1.0.0
 * Purpose: To display last sql ran in the current session.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 175
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum          format   999 	heading "#"
col prev_sql_id     format   a13	heading "SQL Id"
col time            format   a20        heading "Execution Time"

spool &&rpt_dir/sho_last_sql.rpt

select 
	rownum,
        prev_sql_id,
        to_char(prev_exec_start,'DD-MON-YYYY HH:MI AM') time
from 
      v$session 
where 
      sid=sys_context('userenv','sid')
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
