/*
 * Title  : sho_imp_rpm.sql
 * Author : EXADIME LLC
 * Created: 1-Aug-2017
 * Updated: 1-Aug-2017
 * Release: 1.0.0
 * Purpose: To monitor insert/import speed.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 120
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Rownum"		format 999		heading "#"
col "Table Name"	format a30
col "Rows Processed"	format 99G999G999G999
col "Minutes"		format 99G999G999
col "Rows/Min"		format 99G999G999

spool &&rpt_dir/sho_imp_rpm.rpt

select 
	rownum,
	substr(sql_text,instr(sql_text,'INTO "'),30) "Table Name",
	rows_processed "Rows Processed",
	round((sysdate-to_date(first_load_time,'yyyy-mm-dd hh24:mi:ss'))*24*60,1) "Minutes",
	trunc(rows_processed/((sysdate-to_date(first_load_time,'yyyy-mm-dd hh24:mi:ss'))*24*60)) "Rows/Min"
from   
	sys.v_$sqlarea
where  
	sql_text like 'INSERT %INTO "%'
and	command_type = 2
and	open_versions > 0;

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
