/*
 * Title  : sho_eg.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Show script example.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column id	format 9,999,999	heading "File ID"
column name	format a60		heading "File Name"
column total	format 99,999,999,999	heading "Total"
column occupied	format 99,999,999,999	heading "Occupied"
column hwm	format 99,999,999,999	heading "KBytes|High Water Mark"
column auto	format a5		heading "Auto?"

compute sum of total	on report
compute sum of occupied on report
compute sum of hwm 	on report

break on report

accept p_file_id char prompt "Enter Data File ID "

spool &&rpt_dir/sho_ex.rpt

<select query>

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
