/*
 * Title  : sho_dead_lock.sql
 * Author : EXADIME LLC
 * Created: 31-Mar-2018
 * Updated: 31-Aug-2018
 * Release: 1.0.0
 * Purpose: This script shows dead locks in the database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col sno	    format 9999 heading "#"
col sno     format 9999 heading "SID"
col Blocker format a60  heading "Blocker [SID/Serial#/User/Machine/SQL]"
col Waiter  format a60  heading "Waiter [SID/Serial#/User/Machine/SQL]"

spool &&rpt_dir/sho_dead_lock.rpt

select
	rownum	sno,
	(select sid ||'/'||serial#||'/'||username||'/'||machine||'/'||sql_id from v$session where sid=a.sid) blocker,
	(select sid ||'/'||serial#||'/'||username||'/'||machine||'/'||sql_id from v$session where sid=b.sid) waiter
from
	v$lock a,
	v$lock b
where
	a.block=1
and	b.request>0
and	a.id1=b.id1
and	a.id2=b.id2;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
