/*
 * Title  : sho_aud_act.sql
 * Author : EXADIME LLC
 * Created: 08-Jan-2021
 * Updated: 08-Jan-2021
 * Release: 1.0.0
 * Purpose: Shows audit actions in the database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 999		heading "#"
col dbusername		format a20		heading "Login User"
col object_schema	format a20		heading "Schema"
col object_name		format a20		heading "Object"
col action		format a10		heading "Action"
col event_timestamp	format a30		heading "Time"

accept p_bt prompt 'Enter begin time (MM/DD/YYYY HH24:MI:SS):'
accept p_et prompt 'Enter end time (MM/DD/YYYY HH24:MI:SS):'
accept p_order char prompt 'Enter order by column {1|2|3|4|5|6} [asc|desc]: ' default 6

spool &&rpt_dir/sho_aud_act.rpt

select 
	row_number() over(order by &&p_order)	sno,
	dbusername,
	object_schema,
	object_name,
	action_name,
	event_timestamp
from (
	select 
		rownum,
		dbusername,
		object_schema,
		object_name,
		action_name,
		event_timestamp 
	from 
		unified_audit_trail 
	where 
		event_timestamp between to_timestamp('&&p_bt','mm/dd/yyyy hh24:mi:ss') and to_timestamp('&&p_bt','mm/dd/yyyy hh24:mi:ss')
	and 	dbusername not in (
			'SYS',
			'SYSTEM',
			'AUDSYS',
			'GSMADMIN_INTERNAL'
			,'GSMCATUSER'
			,'GSMUSER'
			,'OJVMSYS'
			,'SYSBACKUP'
			,'SYSKM'
			,'XS$NULL'
			,'SYSDG',
			'DBSNMP',
			'OUTLN',
			'MDSYS',
			'ORDSYS',
			'ORDPLUGINS',
			'CTXSYS',
			'DSSYS',
			'WKPROXY',
			'WKSYS',
			'WMSYS',
			'XDB',
			'ANONYMOUS',
			'ODM',
			'ODM_MTR',
			'OLAPSYS',
			'TRACESVR',
			'PERFSTAT',
			'REPADMIN',
			'EXFSYS',
			'DMSYS',
			'SYSMAN',
			'DIP',
			'TSMSYS',
			'DVF',
			'DVSYS',
			'WKUSER',
			'WK_TEST',
			'LBACSYS',
			'SI_INFORMTN_SCHEMA',
			'APPQOSSYS',
			'ORACLE_OCM',
			'RMAN',
			'ORACLE',
			'SYS$UMF',
			'GGSYS',
			'DBSFWUSER',
			'ORADBA',
			'REMOTE_SCHEDULER_AGENT',
			'SYSRAC',
			'ORDDATA',
			'MDDATA',
			'SPATIAL_CSW_ADMIN_USR'
	)
) order by
	&&p_order;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off