/*
 * Title  : sho_app_role.sql
 * Author : EXADIME LLC
 * Created: 29-Sep-2025
 * Updated: 29-Sep-2025
 * Release: 1.0.0
 * Purpose: Shows Non System roles (12c or above).
 * Comment: Does not work in 11g or below.
 * Tags:
 * History: None
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 200
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"				format 999
col "Role"			format a30	heading "Role"
col "Password?"		        format a09
col "Inherited?"		format a10
col "Authentication"		format a14

accept p_txt char prompt "Enter search string (E.g. Role): "
accept p_order_col char prompt "Enter order by column {1|2|3|4} [asc|desc] " default 2

spool &&rpt_dir/sho_app_role.rpt

select 
	row_number() over(order by &&p_order_col)       "#",
	role						"Role",
	password_required				"Password?",
	inherited					"Inherited?",
	authentication_type				"Authentication"
from
	dba_roles
where
	oracle_maintained='N'
and
	(role like upper('%&&p_txt%'))
order by
	&&p_order_col
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
